## setting the working directory

setwd("C:/.../R-Codes_EMS_2013")

# seting the memory size
memory.limit(size=2^12-1)


# loading packages
library(tseries)
library(xtable)
library(vars)
library(moments)
library(reshape)

# uploading functions
source("Functions/adf.boot.r")
source("Functions/dummy.r")
source("Functions/startest.r")
source("Functions/star.r")

# uploading data from the NOAA website
ensodat <- read.table("http://www.cpc.ncep.noaa.gov/data/indices/ersst3b.nino.mth.ascii",header=TRUE)

nit <- yrmax # total number of forecasted years (from the 'estimate' code)
nboot <- 1000 # total number of boostraps (usually: 1000; for a test-run: 50)

b.r.vec <- matrix(,nit*12,1)
for(i in 1:nit){
for(j in 0:11){
b.r.vec[((i-1)*12+(j+1)),] <- nrow(as.matrix(read.table(file=paste("Estimates/beta_e_",(1990+i),"_",j,".txt",sep=""),header=FALSE,sep=",",na.strings="NA",dec=".",strip.white=TRUE)))
}
}


b.e.array <- array(0,dim=c(max(b.r.vec),3,nit*12))
for(i in 1:nit){
for(j in 0:11){
maxn <- nrow(as.matrix(read.table(file=paste("Estimates/beta_e_",(1990+i),"_",j,".txt",sep=""),header=FALSE,sep=",",na.strings="NA",dec=".",strip.white=TRUE)))
b.e.array[1:(maxn-11),,((i-1)*12+(j+1))] <- as.matrix(read.table(file=paste("Estimates/beta_e_",(1990+i),"_",j,".txt",sep=""),header=FALSE,sep=",",na.strings="NA",dec=".",strip.white=TRUE))[1:(maxn-11),]
b.e.array[(max(b.r.vec)-10):(max(b.r.vec)),,((i-1)*12+(j+1))] <- as.matrix(read.table(file=paste("Estimates/beta_e_",(1990+i),"_",j,".txt",sep=""),header=FALSE,sep=",",na.strings="NA",dec=".",strip.white=TRUE))[(maxn-10):(maxn),]
}
}


t.e.array <- array(,dim=c(4,nit*12))
for(i in 1:nit){
for(j in 0:11){
t.e.array[,((i-1)*12+(j+1))] <- as.matrix(read.table(file=paste("Estimates/tran_e_",(1990+i),"_",j,".txt",sep=""),header=FALSE,sep=",",na.strings="NA",dec=".",strip.white=TRUE))[1:4,]
}   
}   


SSTA <- as.matrix(ensodat[,10])
enso.f <- as.matrix(SSTA)

n <- nrow(SSTA)

# nmax <- round(n/12)*12
# tmax <- round((nmax/12)*(2/3))*12
# 
# hor <- 36
# 
# yrmax <- (nmax-tmax-hor)/12
# momax <- 12


for(d in 1:yrmax){
for(z in 1:momax){

enso <- as.matrix(enso.f[(1):(tmax+(d-1)*12+z-1),])

# total number of observations
n.e <- nrow(enso) # also equal to n
l.e <- 24 # maximum lag length

# creating matrix of dummy variables

p.e <- max(t.e.array[4,])

enso.d <- as.matrix(diff(enso))
n.e.d <- n.e-1
l.e.d <- l.e-1
p.e.d <- p.e-1

# creating a matrix of lagged enso variable

l.enso.mat <- matrix(0,(n.e-l.e),l.e)
for (i in 1:(n.e-l.e)){
  for (j in 1:l.e){
    l.enso.mat[i,j] <- enso[(l.e+i+1-j),1]
  }
}

# creating a matrix of lagged differenced enso

l.enso.d.mat <- matrix(0,(n.e.d-l.e.d),l.e.d)
for (i in 1:(n.e.d-l.e.d)){
  for (j in 1:l.e.d){
    l.enso.d.mat[i,j] <- enso.d[(l.e.d+i+1-j),1]
  }
}

# creating a vector of dependent and a matrix of independent variables

enso.dep <- as.matrix(l.enso.d.mat[,1])
enso.l <- as.matrix(l.enso.mat[,2])
enso.d.mat <- as.matrix(l.enso.d.mat[,2:p.e])
dum.mat <- dummy(n.e,12,1)[(l.e+1):(n.e),]       

enso.ind <- cbind(1,enso.l,enso.d.mat,dum.mat)

# estimates
b.e.l <- as.matrix(b.e.array[,1,((d-1)*12+(z))])
b.e.1 <- as.matrix(b.e.array[,2,((d-1)*12+(z))])
b.e.2 <- as.matrix(b.e.array[,3,((d-1)*12+(z))])

t.e.1 <- as.matrix(t.e.array[2,((d-1)*12+(z))])
t.e.2 <- as.matrix(t.e.array[3,((d-1)*12+(z))])

# Linear Regression Residuals
resid.e.l <- enso.dep - enso.ind%*%b.e.l

# creating a matrix of transition variables
trans.var.enso <- enso

### Smooth Transition Autoregression

d.e <- t.e.array[1,((d-1)*12+(z))]
s.e <- as.matrix(trans.var.enso[(25-d.e):(nrow(trans.var.enso)-d.e),1])
f.e <- "l"
b.e <- c(b.e.1,b.e.2,t.e.1,t.e.2)

fit.e <- star.pred(b.e,enso.dep,enso.ind,enso.ind,s.e,model=f.e,ghat=NULL)
pred.e   <- fit.e$pred
resid.e  <- fit.e$resid
trans.e  <- fit.e$trans


memory.limit(size=4095)

hor <- 36
dum.mat.h <- dummy((n.e-l.e+hor),12,1)

e.l.for <- matrix(,(hor+l.e),nboot)
e.n.for <- matrix(,(hor+l.e),nboot)

enso.for.l <- matrix(,(hor+1),nboot)
enso.for.n <- matrix(,(hor+1),nboot)

enso.ssn.l <- matrix(,(hor+1),nboot)
enso.ssn.n <- matrix(,(hor+1),nboot)


boot.e.l <- matrix(,(hor),nboot)
boot.e.n <- matrix(,(hor),nboot)

res.vec.l <- c(resid.e.l,resid.e.l[1:hor,])
res.vec.n <- c(resid.e,resid.e[1:hor,])

block.numb <- 3
block.size <- hor/block.numb

for(i in 1:nboot){
  
block.intg <- sample(c(1:length(resid.e)),3)

resid.vec.l <- c(res.vec.l[(block.intg[1]):(block.intg[1]+block.size-1)],res.vec.l[(block.intg[2]):(block.intg[2]+block.size-1)],res.vec.l[(block.intg[3]):(block.intg[3]+block.size-1)])

resid.vec.n <- c(res.vec.n[(block.intg[1]):(block.intg[1]+block.size-1)],res.vec.n[(block.intg[2]):(block.intg[2]+block.size-1)],res.vec.n[(block.intg[3]):(block.intg[3]+block.size-1)])

boot.e.l[,i] <- resid.vec.l
boot.e.n[,i] <- resid.vec.n
}


for(k in 1:nboot){

boot.e.l.k <- boot.e.l[,k]
boot.e.n.k <- boot.e.n[,k]

e0 <- as.matrix(enso[(n.e-l.e+1):(n.e)])
eh <- matrix(,hor,1)
e.l <- rbind(e0,eh)
e.n <- rbind(e0,eh)

erhs0 <- enso.ind[(n.e-l.e),]
erhsh <- matrix(,(hor),ncol(enso.ind))

erhs.l <- rbind(erhs0,erhsh)
erhs.n <- rbind(erhs0,erhsh)

erhs.l[,1] <- 1
erhs.n[,1] <- 1
erhs.l[2,2] <- e.l[(l.e),]
erhs.n[2,2] <- e.n[(l.e),]
erhs.l[2,3] <- e.l[l.e,]-e.l[(l.e-1),]
erhs.n[2,3] <- e.n[l.e,]-e.n[(l.e-1),]
erhs.l[2,4:(p.e+1)] <- erhs.l[1,3:(p.e)]
erhs.n[2,4:(p.e+1)] <- erhs.n[1,3:(p.e)]
erhs.l[,(p.e+2):ncol(enso.ind)] <- dum.mat.h[(n.e-l.e):(n.e-l.e+hor),]
erhs.n[,(p.e+2):ncol(enso.ind)] <- dum.mat.h[(n.e-l.e):(n.e-l.e+hor),]

ensovec.l <- matrix(,(hor),1)
ensovec.n <- matrix(,(hor),1)

for(m in 1:(hor-1)){
trvar01 <- e.n[(l.e+m-d.e),]
trfun1 <- (1+exp(-(t.e.1/apply(s.e,2,sd))*(trvar01-t.e.2)))^(-1)
ensodep.n <- erhs.n[(m+1),]%*%b.e.1+(erhs.n[(m+1),]%*%b.e.2)*trfun1+boot.e.n.k[m]
ensodep.l <- erhs.l[(m+1),]%*%b.e.l+boot.e.l.k[m]
ensovec.n[m,] <- ensodep.n
ensovec.l[m,] <- ensodep.l
ensolev.n <- erhs.n[(m+1),2]+ensodep.n
ensolev.l <- erhs.l[(m+1),2]+ensodep.l
e.n[l.e+m] <- ensolev.n
e.l[l.e+m] <- ensolev.l
erhs.n[(m+2),2:(p.e+1)] <- c(ensolev.n,ensodep.n,erhs.n[(m+1),3:p.e])
erhs.l[(m+2),2:(p.e+1)] <- c(ensolev.l,ensodep.l,erhs.l[(m+1),3:p.e])
}       
trvar01 <- e.n[(l.e+hor-d.e),]
trfun1 <- (1+exp(-(t.e.1/apply(s.e,2,sd))*(trvar01-t.e.2)))^(-1)
ensodep.n <- erhs.n[(hor+1),]%*%b.e.1+(erhs.n[(hor+1),]%*%b.e.2)*trfun1+boot.e.n.k[hor]
ensodep.l <- erhs.l[(hor+1),]%*%b.e.l+boot.e.l.k[hor]
ensovec.n[hor,] <- ensodep.n
ensovec.l[hor,] <- ensodep.l
ensolev.n <- erhs.n[(hor+1),2]+ensodep.n
ensolev.l <- erhs.l[(hor+1),2]+ensodep.l
e.n[l.e+hor] <- ensolev.n
e.l[l.e+hor] <- ensolev.l


e.l.for[,k] <- e.l
e.n.for[,k] <- e.n

enso.for.l[,k] <- e.l[(l.e+1-1):(l.e+hor),]
enso.for.n[,k] <- e.n[(l.e+1-1):(l.e+hor),]

for(ssn in 1:(hor+1)){
  enso.ssn.l[ssn,k] <- mean(e.l[(l.e-3+ssn):(l.e-1+ssn),]) 
  enso.ssn.n[ssn,k] <- mean(e.n[(l.e-3+ssn):(l.e-1+ssn),])
}


}     



enso.mean.l     <- round(rowMeans(enso.for.l),4)
enso.mean.n     <- round(rowMeans(enso.for.n),4)
enso.mean.ssn.l <- round(rowMeans(enso.ssn.l),4)
enso.mean.ssn.n <- round(rowMeans(enso.ssn.n),4)
enso.actual     <- round(c(enso.f[(tmax+(d-1)*12+z-1):(tmax+(d-1)*12+z+hor-1),]),4)
enso.actual.ssn <- matrix(,(hor+1),1)
for(ssn in 1:(hor+1)){
  enso.actual.ssn[ssn,] <- mean(enso.f[(tmax+(d-1)*12+z-1+ssn-3):(tmax+(d-1)*12+z-1+ssn-1),]) 
}
enso.actual.ssn <- round(c(enso.actual.ssn),4)


datall.l <- matrix(,5,(hor+1))
for(i in 1:(hor+1)){
  sst.cdf.l <- ecdf(enso.for.l[i,])
  probs.l <- sst.cdf.l(c(-.9,-.45,.45,.9))
  
  dat1.l <- probs.l[1]
  dat2.l <- probs.l[2]-probs.l[1]
  dat3.l <- probs.l[3]-probs.l[2]
  dat4.l <- probs.l[4]-probs.l[3]
  dat5.l <- 1-probs.l[4]
  
  datall.l[,i] <- c(dat1.l,dat2.l,dat3.l,dat4.l,dat5.l)
}


datall.n <- matrix(,5,(hor+1))
for(i in 1:(hor+1)){
  sst.cdf.n <- ecdf(enso.for.n[i,])
  probs.n <- sst.cdf.n(c(-.9,-.45,.45,.9))
  
  dat1.n <- probs.n[1]
  dat2.n <- probs.n[2]-probs.n[1]
  dat3.n <- probs.n[3]-probs.n[2]
  dat4.n <- probs.n[4]-probs.n[3]
  dat5.n <- 1-probs.n[4]
  
  datall.n[,i] <- c(dat1.n,dat2.n,dat3.n,dat4.n,dat5.n)
}




datall.ssn.l <- matrix(,5,(hor+1))
for(i in 1:(hor+1)){
sst.cdf.l <- ecdf(enso.ssn.l[i,])
probs.l <- sst.cdf.l(c(-.9,-.45,.45,.9))

dat1.l <- probs.l[1]
dat2.l <- probs.l[2]-probs.l[1]
dat3.l <- probs.l[3]-probs.l[2]
dat4.l <- probs.l[4]-probs.l[3]
dat5.l <- 1-probs.l[4]

datall.ssn.l[,i] <- c(dat1.l,dat2.l,dat3.l,dat4.l,dat5.l)
}


datall.ssn.n <- matrix(,5,(hor+1))
for(i in 1:(hor+1)){
sst.cdf.n <- ecdf(enso.ssn.n[i,])
probs.n <- sst.cdf.n(c(-.9,-.45,.45,.9))

dat1.n <- probs.n[1]
dat2.n <- probs.n[2]-probs.n[1]
dat3.n <- probs.n[3]-probs.n[2]
dat4.n <- probs.n[4]-probs.n[3]
dat5.n <- 1-probs.n[4]

datall.ssn.n[,i] <- c(dat1.n,dat2.n,dat3.n,dat4.n,dat5.n)
}


enso.l.mat <- cbind(enso.actual,enso.mean.l)
enso.n.mat <- cbind(enso.actual,enso.mean.n)

enso.l.ssn.mat <- cbind(enso.actual.ssn,enso.mean.ssn.l)
enso.n.ssn.mat <- cbind(enso.actual.ssn,enso.mean.ssn.n)

write.table(enso.l.mat,file=paste("Forecasts/enso_l_",(1990+d),"_",(z),".txt",sep=""),quote=FALSE,sep=",",row.names=FALSE,col.names=FALSE)
write.table(enso.n.mat,file=paste("Forecasts/enso_n_",(1990+d),"_",(z),".txt",sep=""),quote=FALSE,sep=",",row.names=FALSE,col.names=FALSE)

write.table(enso.l.ssn.mat,file=paste("Forecasts/enso_l_ssn_",(1990+d),"_",(z),".txt",sep=""),quote=FALSE,sep=",",row.names=FALSE,col.names=FALSE)
write.table(enso.n.ssn.mat,file=paste("Forecasts/enso_n_ssn_",(1990+d),"_",(z),".txt",sep=""),quote=FALSE,sep=",",row.names=FALSE,col.names=FALSE)


write.table(datall.l,file=paste("Forecasts/prob_l_",(1990+d),"_",(z),".txt",sep=""),quote=FALSE,sep=",",row.names=FALSE,col.names=FALSE)
write.table(datall.n,file=paste("Forecasts/prob_n_",(1990+d),"_",(z),".txt",sep=""),quote=FALSE,sep=",",row.names=FALSE,col.names=FALSE)

write.table(datall.ssn.l,file=paste("Forecasts/prob_l_ssn_",(1990+d),"_",(z),".txt",sep=""),quote=FALSE,sep=",",row.names=FALSE,col.names=FALSE)
write.table(datall.ssn.n,file=paste("Forecasts/prob_n_ssn_",(1990+d),"_",(z),".txt",sep=""),quote=FALSE,sep=",",row.names=FALSE,col.names=FALSE)


iternum <- c(d,z)
write(iternum,file="iternum.txt",sep=",",append=FALSE)

}

}


